package gotowe.p25_kolekcje.zbieranie_danych;

import java.util.Map;
import java.util.Scanner;
import java.util.TreeMap;

public class P6_TreeMap {
	// Podobnie, jak w przypadku zbiorów (Set), dla słowników (Map) mamy takie implementacje,
	// które róznią się kolejnością danych:
	// - HashMap - kolejność techniczna / chaotyczna
	// - LinkedHashMap - kolejność, w jakiej elementy były dodawane po raz pierwszy
	// - TreeMap - dane posortowane wg kluczy
	
	// W zaawansowanych zastosowaniach ważną implementacją słowników jest ConcurrentHashMap,
	// która poprawnie i wydajnie działa w aplikacjach wielowątkowych (rózne wątki mogą korzytać jednocześnie).
	
	public static void main(String[] args) {
		Scanner scanner = new Scanner(System.in);
		
		// W tym słowniku dla imienia osoby pamiętamy wiek tej osoby.
		// String (mię) jest kluczem, Integer (wiek) jest wartością.
		Map<String, Integer> slownik = new TreeMap<>();
		
		while(true) {
			System.out.print("Podaj imię: ");
			// pusty String oznacza koniec
			String imie = scanner.nextLine();
			if(imie.isEmpty()) {
				break;
			}
			System.out.print("Podaj wiek: ");
			int wiek = scanner.nextInt();
			scanner.nextLine();
			slownik.put(imie, wiek);
		}
		
		System.out.println(slownik);
		System.out.println();
		
		// Drugi etap: użytkownik podaje imię, a program odczytuje wartość ze słownika (czyli wiek tej osoby)
		while(true) {
			System.out.print("Podaj imię: ");
			String imie = scanner.nextLine();
			if(imie.isEmpty()) {
				break;
			}
			// podstawową operacją do odczytywania danych ze słownika jest get(klucz)
			// jeśli istnieje wpis o podanym kluczu, to wynikiem jest wartość spod tego klucza
			// jeśli nie istnieje, to wynikiem jest null
			// w związku z tym gdy czytamy dane ze słownika bez wcześniejszego sprawdzenia, czy klucz istnieje,
			// trzeba użyć zmiennej typu obiektowego (tutaj Integer, a nie int)
			Integer wiek = slownik.get(imie);
			if(wiek == null) {
				System.out.println("W słowniku nie osoby " + imie);
			} else {
				System.out.println("Osoba " + imie + " ma " + wiek + " lat");
			}
			
			// Można też użyć operacji containsKey do sprawdzenia, czy słownik zawiera podany klucz
//			if(slownik.containsKey(imie)) {
//				System.out.println("Osoba " + imie + " ma " + slownik.get(imie) + " lat.");
//			} else {
//				System.out.println("W słowniku nie osoby " + imie);
//			}
		}
	}

}
