package emps.v3_funkcyjnie;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

// W tej wersji kolektor groupingBy zbiera rekordy w grupy, ale nie wylicza żadnych statystyk.
// Inne znaczenie słowa "grupowanie", niż w SQL.
public class Grupowanie7 {

	public static void main(String[] args) {
		List<Employee> emps = ObslugaCSV.wczytaj("emps.csv");
		
		Map<String, List<Employee>> grupy = emps.stream().collect(Collectors.groupingBy(Employee::getJobTitle));
		// w tym słowniku dla danego jobTitle znajduje się lista wszystkich pracowników, którzy mają takie jobTitle
		// System.out.println(grupy);
		
		grupy.forEach((job, lista) -> {
			System.out.printf("Stanowisko %s (%d osób):%n", job, lista.size());
			lista.forEach(emp -> {
				System.out.printf(" * %s %s ($%d)%n", emp.getFirstName(), emp.getLastName(), emp.getSalary());
			});
			System.out.println();
		});
	}

}
