package emps.v2_obiektowo;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class Grupowanie1a {

	public static void main(String[] args) {
		final List<Employee> emps = ObslugaCSV.wczytaj("emps.csv");
		
		final Map<String, Integer> sumy = new TreeMap<>();
		final Map<String, Integer> ilosci = new TreeMap<>();

		for(Employee emp : emps) {
			final String jobTitle = emp.getJobTitle();
			if(sumy.containsKey(jobTitle)) {
				sumy.put(jobTitle, sumy.get(jobTitle) + emp.getSalary());
				ilosci.put(jobTitle, ilosci.get(jobTitle)+1);
			} else {
				sumy.put(jobTitle, emp.getSalary());
				ilosci.put(jobTitle, 1);
			}
		}

		for(String job : sumy.keySet()) {
			final int suma = sumy.get(job);
			final int ile = ilosci.get(job);
			final double srednia = (double)suma / ile;
			System.out.printf("| %-32s | %2d | %8.2f |%n", job, ile, srednia);
		}
	}
}
