package com.example.demo.wstrzykiwanie;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class Inject3 {
	{ System.out.println("Inject3 init"); }

	// 3. sposób wstrzykiwania: konstruktor
	// To podejście zwykle jest podawane jako najlepsze, bo umożliwia łatwą podmianę komponentów na "mocki" podczas testów
	private Komponent komponent;
	private Repo repo;
	
	// Zauważmy, że ta klasa nie jest już poprawnym "JavaBean", bo nie posiada konstruktora domyślnego.
	// Adnotacja Autowired tym razem nie jest potrzebna.
	public Inject3(Komponent komponent, Repo repo) {
	    System.out.println("KONSTRUKTOR Inject3(komponent, repo)");
		this.komponent = komponent;
		this.repo = repo;
	}

	@RequestMapping("/inject3")
	@ResponseBody
	public String get() {
		return repo.getText() + " " + komponent.getValue();
	}

}
