package sklep.security;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.web.SecurityFilterChain;

@Configuration
public class SecurityConfig {
	// W klasie typu Configuration umieszczamy metody, które w wyniku zwracają obiekty, które dla Springa coś specjalnego znaczą.
	// Te metody oznaczamy adnotacją @Bean.
	// (w ten sposób można też stworzyć "własne" beany, zamiast podejścia z adnotacją @Component)
	@Bean
	SecurityFilterChain setHttpSecurity(HttpSecurity httpSecurity) throws Exception {
		httpSecurity.authorizeRequests()
			.anyRequest().permitAll()
			.and().csrf().disable();
		return httpSecurity.build();
	}
	
}
