package sklep.przyklady;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.TypedQuery;

import sklep.model.Product;

public class OdczytajWszystkieProdukty3_Stream {

	public static void main(String[] args) {
		EntityManagerFactory emf = Persistence.createEntityManagerFactory("sklep");
		EntityManager em = emf.createEntityManager();
		
		// W tej wersji wyniki zapytania odczytamy nie jako listę, tylko jako strumień.
		// Dzięki temu nie czytamy wszystkich rekordów na raz i możemy przetwarzać nawet duże tabele.
		TypedQuery<Product> query = em.createNamedQuery("Product.findAll", Product.class);
		query.getResultStream().forEach(product -> {
			System.out.println(" * " + product.getProductName() + " za cenę " + product.getPrice() + ", opis: " + product.getDescription());			
		});
		
		em.close();
		emf.close();
	}

}
