package sklep.przyklady;

import java.util.Scanner;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;

import sklep.model.Product;

public class OdczytajJedenProdukt2 {

	public static void main(String[] args) {
		EntityManagerFactory emf = null;
		EntityManager em = null;
		try {
			Scanner sc = new Scanner(System.in);
			emf = Persistence.createEntityManagerFactory("sklep");
			em = emf.createEntityManager();
			
			System.out.println("Aby zakończyć, podaj liczbę 0");
			while(true) {
				System.out.print("\nPodaj id produktu: ");
				int id = sc.nextInt();
				if(id == 0) break;
			
				Product product = em.find(Product.class, id);
				if(product != null) {
					System.out.println("Odczytany produkt: " + product);
					System.out.println(product.getProductName() + " za cenę " + product.getPrice() + ", opis: " + product.getDescription());
				} else {
					System.out.println("Nie ma produktu o id " + id);
				}
			}
		} catch(Exception e) {
			e.printStackTrace();
		} finally {
			if(em != null)
                em.close();
            if(emf != null)
                emf.close();
		}
	}
}
