package kalkulator;

import java.io.IOException;
import java.io.PrintWriter;

import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@WebServlet("/Kalkulator4")
public class Kalkulator4 extends HttpServlet {
	private static final long serialVersionUID = 1L;

	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		PrintWriter out = naglowkiHTTP(response);
		poczatekHTML(out);
		wypiszFormularz(out);
		koniecHTML(out);
	}
	
	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		PrintWriter out = naglowkiHTTP(response);
		poczatekHTML(out);
		wypiszFormularz(out);
		pobierzParametryIOblicz(request, out);
		koniecHTML(out);
	}

	private PrintWriter naglowkiHTTP(HttpServletResponse response) throws IOException {
		response.setContentType("text/html");
		response.setCharacterEncoding("utf-8");
		PrintWriter out = response.getWriter();
		return out;
	}

	private void poczatekHTML(PrintWriter out) {
		out.println("<!DOCTYPE html>");
		out.println("<html>");
		out.println("<head>");
		out.println("<title>Kalkulator serwletowy</title>");
		out.println("<link rel='stylesheet' type='text/css' href='styl.css'>");
		out.println("</head>");
		out.println("<body>");
		out.println("<h1>Kalkulator 4</h1>");
	}

	private void koniecHTML(PrintWriter out) {
		out.println("</body>");
		out.println("</html>");
	}

	private void wypiszFormularz(PrintWriter out) {
		out.println("<form method='post'>");
		out.println("<p>Wpisz liczby i wybierz działanie:</p>");		
		out.println("<input name='liczba1' type='number'>");
		out.println("<select name='operacja'>");
		out.println("<option value='+'>+</option>");
		out.println("<option value='-'>-</option>");
		out.println("<option value='*'>*</option>");
		out.println("<option value='/'>/</option>");
		out.println("</select>");		
		out.println("<input name='liczba2' type='number'>");
		out.println("<button>=</button>");
		out.println("</form>");
	}

	private void pobierzParametryIOblicz(HttpServletRequest request, PrintWriter out) {
		String param1 = request.getParameter("liczba1");
		String param2 = request.getParameter("liczba2");
		String operacja = request.getParameter("operacja");
		try {
			long liczba1 = Long.parseLong(param1);
			long liczba2 = Long.parseLong(param2);
			long wynik = oblicz(liczba1, liczba2, operacja);
			out.printf("<div class='wynik'>%d %s %d = <strong>%d</strong></div>\n",
					liczba1, operacja, liczba2, wynik);
		} catch (NumberFormatException e) {
			out.printf("<div class='error'>Niepoprawny format liczby</div>\n");
		} catch(Exception e) {
			out.printf("<div class='error'>Błąd: %s</div>\n", e.getMessage());				
		}
	}

	private long oblicz(long liczba1, long liczba2, String operacja) {
		return switch(operacja) {
			case "+" -> liczba1 + liczba2;
			case "-" -> liczba1 - liczba2;
			case "*" -> liczba1 * liczba2;
			case "/" -> liczba1 / liczba2;
			default -> throw new IllegalArgumentException("Nieznane działanie: " + operacja);
		};
	}

}
