package alx.p06_funkcje.przyklady;

import java.util.Scanner;

public class Geometria {
	private Geometria() {
		// aby nikt nie tworzył instancji tej klasy, bo to jest "utility class"
	}

	public static double poleKwadratu(double a) {
		return a * a;  // ew. Math.pow(a, 2)
	}
	
	public static double poleKola(double r) {
		//JOptionPane.showMessageDialog(null, "Właśnie zabieram się za obliczanie pola koła o promieniu " + r);
		return Math.PI * Math.pow(r, 2);
	}
	
	public static double poleProstokata(double a, double b) {
		return a * b;
	}
	
	public static double obwodKwadratu(double a) {
		return 4*a;
	}

	public static double obwodProstokata(double a, double b) {
		return 2*a + 2*b;
	}

	public static double obwodKola(double r) {
		return 2 * Math.PI * r;
	}

	// W tej wersji main jest w tej samej klasie, co definicje funkcji,
	// dzięki temu można łatwo te funkcje (statyczne) wywoływać.
	// Ale dla przejrzystości kodu lepiej funkcje definiować w jednej klasie, a program (main) pisać w innej - zob. ProgramGeometryczny)
	public static void main(String[] args) {
		Scanner sc = new Scanner(System.in);
		
		System.out.print("Podaj pierwszą liczbę: ");
		double x = sc.nextDouble();

		System.out.print("Podaj drugą liczbę: ");
		double y = sc.nextDouble();
		
		double wynik;
		wynik = poleKwadratu(x);
		System.out.println("Pole kwadratu o boku " + x + " wynosi " + wynik);
		wynik = poleKwadratu(y);
		System.out.println("Pole kwadratu o boku " + y + " wynosi " + wynik);
		
		wynik = poleProstokata(x, y);
		System.out.println("Pole prostokąta " + x + " × " + y + " wynosi " + wynik);
		
		wynik = poleKola(x);
		System.out.println("Pole koła o promieniu " + x + " wynosi " + wynik);
		wynik = poleKola(y);
		System.out.println("Pole koła o promieniu " + y + " wynosi " + wynik);

		wynik = obwodKwadratu(x);
		System.out.println("Obwód kwadratu o boku " + x + " wynosi " + wynik);
		wynik = obwodKwadratu(y);
		System.out.println("Obwód kwadratu o boku " + y + " wynosi " + wynik);
		
		// tak też można pisać, ale po co?...
		wynik = Geometria.obwodProstokata(x, y);
		System.out.println("Obwód prostokąta " + x + " × " + y + " wynosi " + wynik);
	}

}
