package emps.strumieniowo;

import java.util.Comparator;
import java.util.List;
import java.util.Optional;

public class P5_MinMax_v2 {

	public static void main(String[] args) {
		List<Employee> emps = ObslugaCSV.wczytaj("emps.csv");

		Optional<Employee> min = emps.stream().min(Comparator.comparingInt(Employee::getSalary));
		Optional<Employee> max = emps.stream().max(Comparator.comparingInt(Employee::getSalary));
		
		System.out.println(min);
		System.out.println(max);
		System.out.println();
		
		if(min.isPresent()) {
			Employee minEmp = min.get();
			System.out.printf("Najmniej zarabia %s %s (%s): %d%n",
					minEmp.getFirstName(), minEmp.getLastName(), minEmp.getJobTitle(), minEmp.getSalary());
		}
		
		if(max.isPresent()) {
			Employee maxEmp = max.get();
			System.out.printf("Najwięcej zarabia %s %s (%s): %d%n",
					maxEmp.getFirstName(), maxEmp.getLastName(), maxEmp.getJobTitle(), maxEmp.getSalary());
		}
	}

}
