package emps.obiektowo;

import java.util.List;

// Program wypsiuje pracowników w kolejności posortowanej zwn pensje.

public class P7a_Sortowanie {

	public static void main(String[] args) {
		List<Employee> emps = ObslugaCSV.wczytaj("emps.csv");
		
		// Listę można posortować, ale:
		// 1) albo elementy tej listy muszą implementować interfejs Comparable, czyli "same potrafią się porównać"
		// (tak jest dla String, Integer, BigDecimal, LocalDate)
		// 2) albo musimy przekazać parametr Comparator, który określa kolejność elementów
		// Tutaj sposób 2)
		
		// W tej wersji Comparator zdefiniujemy za pomocą wyrażenia lambda.
		// Tutaj używam zwykłego odejmowania int-ów, co jest poprawne gdy oba inty są dodatnie.
		emps.sort((emp1, emp2) -> emp1.getSalary() - emp2.getSalary());
		
		for(Employee emp : emps) {
			System.out.println(emp);
		}
	}

}
