package emps.obiektowo;

import java.io.File;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;

public class P4b_SredniaWybranych_Interaktywnie {
// W tej wersji użytkownik będzie mógł wybrać plik z dysku i wskazać stanowisko, dla którego ma być wylicozna średnia.
	
	public static void main(String[] args) {
		JFileChooser chooser = new JFileChooser(".");
		chooser.setDialogTitle("Wybierz plik z danymi pracowników");
		chooser.setFileFilter(new FileNameExtensionFilter("Pliki CSV", "csv", "txt"));
		int coSieStalo = chooser.showOpenDialog(null);
		if(coSieStalo != JFileChooser.APPROVE_OPTION) {
			return;
		}
		File wybranyPlik = chooser.getSelectedFile();
		List<Employee> emps = ObslugaCSV.wczytaj(wybranyPlik);
		Set<String> jobs = new TreeSet<>();
		for (Employee emp : emps) {
			jobs.add(emp.getJobTitle());
		}
		
		String wybranyJob = (String)JOptionPane.showInputDialog(null,
				"Czyją średnią chcesz obliczyć?",
				"Wybierz stanowsiko",
				JOptionPane.QUESTION_MESSAGE,
				null,
				jobs.toArray(),
				null);
		
		double suma = 0;
		int ile = 0;
		for (Employee emp : emps) {
			if(emp.getJobTitle().equalsIgnoreCase(wybranyJob)) {
				suma += emp.getSalary();
				ile++;
			}
		}

		double srednia = suma / ile;
		JOptionPane.showMessageDialog(null, "Średnia pensja na stanowisku " + wybranyJob + " wynosi " + srednia);
	}

}
