package emps.obiektowo;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

public class MergeDodatkowe {
	public static void main(String[] args) {
		List<Employee> emps = ObslugaCSV.wczytaj("emps.csv");
		Map<String, String> mapa = new HashMap<>();
		
		// przykład pokazujący, że merge działa też dla innych typów niż liczbowe
		// uwaga: łączenie tekstów w ten sposób (za pomocą concat lub + w pętli) jest mało wydajny - to nie jest wzór do naśladowania
		// prawidłowo byłoby uzyć StringBuildera w pętli lub Collectors.join
		for(Employee emp : emps) {
			mapa.merge(emp.getJobTitle(), emp.getLastName(), String::concat);
		}
		
		for (Entry<String, String> entry : mapa.entrySet()) {
			System.out.println(entry.getKey() + ": " + entry.getValue());
		}
	}
}
