package biblioteki;

import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class CommonsLang {

    public static void main(String[] args) {
        String[] t = {null, "Ala", "Agnieszka", "Zenon", "Żaneta", "Łukasz", "Łucja", "ala", "łukasz", "", "   "};
        
        // Gdy w Javie porównujemy Stirngi (i inne obiekty), robimy to za pomocą equals.
        // Gdybyśmy próbowali wywołać equals na zmiennej, która może by nullem, to doprowadzimy do błędu NPE
        
//        for(int i = 2; i >= 0; i--) {
//        	if(t[i].equals("Ala")) {
//        		System.out.println(i + " to jest Ala");
//        	} else {
//        		System.out.println(i + " to nie jest Ala");
//        	}
//        }
        
        // Dlatego zalecane jest, aby zmienne porównywać z konkretnymi napisami w tej kolejności:
        // "Napis".equals(zmienna)
        // a nie zmienna.equals("Napis")
        for(int i = 2; i >= 0; i--) {
        	if("Ala".equals(t[i])) {
        		System.out.println(i + " to jest Ala");
        	} else {
        		System.out.println(i + " to nie jest Ala");
        	}
        }
        // Jednak czasami porównujemy dwie zmienne, z których obie mogą być nullem, wtedy jest trudniej.
        // Biblioteka commons-lang i klasa StringUtils pomaga w operacjach porównywania, sprawdzania czy napis jest pusty itd.
        
        
        System.out.println();
        
        // Porównania stringów, które są odporne na wartości null (nie pojawiają się błędy)
        System.out.println(StringUtils.equalsIgnoreCase(t[0], t[7])); // false, bo null != ala
        System.out.println(StringUtils.equalsIgnoreCase(t[1], t[7]));
        System.out.println(StringUtils.equalsIgnoreCase(t[5], t[8])); // Łukasz == łukasz
        System.out.println();
        
        System.out.println(StringUtils.isEmpty(t[0])); // tak, bo jest nullem
        System.out.println(StringUtils.isEmpty(t[9])); // tak, bo jest pustym stringiem
        System.out.println(StringUtils.isEmpty(t[10])); // false, bo zawiera 3 spacje
        System.out.println(StringUtils.isBlank(t[10]));
        System.out.println(StringUtils.isBlank(t[0]));
        System.out.println(StringUtils.isBlank(t[1]));
        System.out.println();
        
        // są też wersje dla wielu wartości na raz
        System.out.println(StringUtils.isAllBlank(t[0], t[9], t[10]));
        System.out.println(StringUtils.isAllBlank(t[0], t[8], t[10]));
        // praktyczne zastosowanie: walidacja danych wprowadzonych przez użytkownika:
        
        String imie = "Ala", nazwisko = "Kowalska", adres = " ";
        if(StringUtils.isAnyBlank(imie, nazwisko, adres)) {
            System.out.println("Nie podałeś danych");
        } else {
            // robimy coś ważnego
        }
        System.out.println();

        for (String s : t) {
            if(StringUtils.isNotEmpty(s)) {
                System.out.println("|" + StringUtils.center(s, 20, '.') + "|");
            }
        }
        System.out.println();
        
        System.out.println(ObjectUtils.firstNonNull(t));
    }

}


