package sklep.przyklady;

import java.util.List;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.TypedQuery;

import sklep.model.Product;

public class OdczytajWszystkieProdukty2_NamedQuery {

	public static void main(String[] args) {
		EntityManagerFactory emf = Persistence.createEntityManagerFactory("sklep");
		EntityManager em = emf.createEntityManager();
		
		// Chcemy wypisać wszystkie produkty.
		// W tej wersji skorzystamy z gotowego "named query".
		
		TypedQuery<Product> query = em.createNamedQuery("Product.findAll", Product.class);
		List<Product> products = query.getResultList();
		System.out.println("Odczytano " + products.size() + " rekordów.");
		for (Product product : products) {
			System.out.println(" * " + product.getProductName() + " za cenę " + product.getPrice() + ", opis: " + product.getDescription());			
		}
		
		em.close();
		emf.close();
	}

}
