
-- numery 1-10 zostawiam na przykładowe produkty, a dopiero od 11 będzie automatyczna numeracja
CREATE SEQUENCE products_seq START 11;

CREATE TABLE products (
	product_id INTEGER DEFAULT nextval('products_seq'),
	product_name VARCHAR(100) NOT NULL, -- tekst o dł maksymalnie 100 znaków
	price NUMERIC(10, 2) NOT NULL, -- max 10 cyfr, z czego 2 to cyfry po przecinku
	vat NUMERIC(2, 2), -- wartości do 0.99
	description TEXT, -- w PostgreSQL TEXT, a w Oracle CLOB to są "duże fragmenty tekstu"
	
	PRIMARY KEY(product_id),
	CHECK(price > 0),
	CHECK(vat >= 0)
);


-- W celach dydaktycznych: kluczem nie musi być liczba, może być tekst
CREATE TABLE customers (
	customer_email VARCHAR(100),
	customer_name VARCHAR(100) NOT NULL,
	phone_number VARCHAR(20),
	address VARCHAR(200),
	postal_code CHAR(6),
	city VARCHAR(100),
	
	PRIMARY KEY(customer_email)
);


CREATE TYPE order_status AS
ENUM('NEW', 'CONFIRMED', 'SHIPPED', 'CLOSED', 'RETURNED');

CREATE SEQUENCE orders_seq START 101;

-- REFERENCES oznacza "klucz obcy", za pomocą tej wartości wskazujemy klienta, który złożył zamówienie
-- technicznie: do pola orders.customer_email można wpisać tylko taką wartość, która wystepuje gdzieś w customers.customer_email
CREATE TABLE orders (
	order_id INTEGER DEFAULT nextval('orders_seq'),
	customer_email VARCHAR(100) NOT NULL,
	status order_status DEFAULT 'NEW' NOT NULL,
	order_date TIMESTAMP DEFAULT current_timestamp NOT NULL,
	delivery_date DATE,
	
	PRIMARY KEY(order_id),
	FOREIGN KEY(customer_email) REFERENCES customers(customer_email)
);

/* Tabela łączy zamówienia z produktami..
   W jednym zamówieniu mogą być różne produkty.
   Ten sam produkt może występować w różnych zamówieniach.
   To jest związaek "wiele do wielu".
   Jeśli w tej tabeli istnieje wpis z order_id=X i product_id=Y,
   to znaczy, że w zamówieniu X występuje produkt Y

   Dodatkowo zaposujemy informację o liczbie sztuk i cenie, po której towar był kupowany.
   W tej tabeli mamy też dwukolumnowy klucz główny, bo kombinacja order_id×product_id
   musi być unikalna.
*/ 
CREATE TABLE order_products (
    order_id INTEGER NOT NULL,
    product_id INTEGER NOT NULL,
    quantity SMALLINT DEFAULT 1 NOT NULL,
    actual_price NUMERIC(10, 2) NOT NULL,
    
    PRIMARY KEY(order_id, product_id),
	FOREIGN KEY(order_id) REFERENCES orders(order_id),
	FOREIGN KEY(product_id) REFERENCES products(product_id),
	CHECK(quantity > 0)
);

