package beans;

import java.time.LocalDateTime;

public class InfoBean {
    /* Klasa jest "Java Bean" jeśli:
     * 1) posiada publiczny konstruktor bezargumentowy (tzw. "default constructor")
     * 2) dostęp do własności ("properties") udostępniony poprzez gettery i settery (nie ma obowiązku aby zawsze była para)
     * ... wzorzec Java Bean opisuje też technikę powiadamiania o zdarzeniach (korzysta się z tego przede wszystkim w GUI), ale w większości przypadków wystarczają te dwie powyższe cechy 
     */

    // konstruktor domyślny jest tworzony automatycznie
    
    private String tekst = "Początkowy napis";
    private int licznik = 0;

    public String getTekst() {
        return tekst;
    }

    public String getTekstDuze() {
        return tekst.toUpperCase();
    }

    public void setTekst(String napis) {
        this.tekst = napis;
    }
    
    public int getLicznik() {
        return ++licznik;
    }
    
    public void setLicznik(int licznik) {
        this.licznik = licznik;
    }
    
    public LocalDateTime getCurrentTime() {
        return LocalDateTime.now();
    }

//  eksperyment: jeśli są dwie metody, to wybiera mała literę
//	public String getcurrentTime() {
//		return "mała litera";
//	}

    
    @Override
    public String toString() {
        return "InfoBean[" + tekst + "]";
    }

}

