package zajecia.postgresql;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;

import javax.swing.JOptionPane;

/* W tej wersji z tabeli są odczytywane wszystkie rekordy, a dopiero nasz program w Javie spr. czy rekord spełnia warunek.
 * Takie podejście jest mało wydajne, co w dużych bazach danych ma fundamentalne znaczenie.
 * 
 * Po pierwsze baza danych musi odczytać wszystkie rekordy z dysku i nie skorzysta z takich technik jak klucze i indeksy.
 * Po drugie dane wszystkich rekordów są transferowane przez sieć.
 * Po trzecie ta aplikacja musi przejrzeć wszystkie rekordy i sprawdzić warunek dla każdego z nich.
 */

public class OdczytajWybranych_v1_If {

	public static void main(String[] args) {
		String szukanyJob = JOptionPane.showInputDialog("Podaj kod stanowiska, np. IT_PROG");
		// TODO wypisz tych pracowników, którzy mają taki job_id

		try(Connection c = DriverManager.getConnection("jdbc:postgresql://localhost:5432/hr", "kurs", "abc123");
			PreparedStatement stmt = c.prepareStatement("SELECT * FROM employees");
			ResultSet rs = stmt.executeQuery()) {
				
			while(rs.next()) {
				String jobId = rs.getString("job_id");
				if(Objects.equals(jobId, szukanyJob)) {
					int id = rs.getInt("employee_id");
					String firstName = rs.getString("first_name");
					String lastName = rs.getString("last_name");
					BigDecimal salary = rs.getBigDecimal("salary");				
					System.out.println("Pracownik nr " + id + ": " + firstName + " " + lastName + " (" + jobId + ") zarabia " + salary);
				}
			}
		} catch (SQLException e) {
			e.printStackTrace();
		}
	}

}
