package pracownicy;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

// To jest klasyczny algorytm grupowania / agregacji z wykorzystaniem słowników.
// To rozwiązanie jest bardziej wydajne niż v1, bo tylko jeden raz przeglądamy listę pracowników,
// a operacje na słownikach (odczyt, zapis, sprawdzanie) są szybkie.
// Tutaj używamy tylko operacji dostępnych w starych wersjach Javy, co najmniej od Javy 5.
public class Grupowanie2 {

	public static void main(String[] args) {
		List<Employee> emps = ObslugaCSV.wczytaj("pracownicy.csv");
		
		Map<String, Integer> sumy = new HashMap<>();
		Map<String, Integer> ilosci= new HashMap<>();
		
		for (Employee emp : emps) {
			if (sumy.containsKey(emp.getJobTitle())) {
				// już wcześniej występowali pracownicy z tego stanowiska
				// trzeba odczytać dotychczasową wartość i zapisać powiększoną
				int dotychczasowaSuma = sumy.get(emp.getJobTitle());
				sumy.put(emp.getJobTitle(), dotychczasowaSuma + emp.getSalary());
				int dotychczasowaIlosc = ilosci.get(emp.getJobTitle());
				ilosci.put(emp.getJobTitle(), dotychczasowaIlosc + 1);
			} else {
				// to jest pierwszy pracownik z danego stanowiska
				sumy.put(emp.getJobTitle(), emp.getSalary());
				ilosci.put(emp.getJobTitle(), 1);
			}
		}
		
//		System.out.println(sumy);
//		System.out.println(ilosci);
		
		for(String job : sumy.keySet()) {
			int suma = sumy.get(job);
			int ilosc = ilosci.get(job);
			double srednia = 1.0 * suma / ilosc;
			System.out.printf("|%32s | %2d | %8.2f |\n", job, ilosc, srednia);
		}
	}

}
