package watki.na_zajeciach;

public class Przeploty {
	private static final int KWOTA = 10;
	private static final int ILE_RAZY = 100_000;

	public static void main(String[] args) {
		Konto konto = new Konto(1, "Ala", 1_000_000);
		System.out.println("Stan początkowy: " + konto.getSaldo());
		
		Thread wplacacz = new Thread(() -> {
			for(int i = 0; i < ILE_RAZY; i++) {
				konto.wplata(KWOTA);
			}
		});

		Thread wyplacacz = new Thread(() -> {
			for(int i = 0; i < ILE_RAZY; i++) {
				try {
					konto.wyplata(KWOTA);
				} catch (BrakSrodkow e) {
					System.err.println(e);
				}
			}
		});

		wplacacz.start();
		wyplacacz.start();
		
		System.out.println("Wątki uruchomione, czekam na koniec");
		try {
			wplacacz.join();
			wyplacacz.join();
		} catch (InterruptedException e) {
			e.printStackTrace();
		}
		
		System.out.println("Wątki zakończone.");
		System.out.println("Stan końcowy: " + konto.getSaldo());
	}

}
