package emps.comparable;

import java.io.File;
import java.io.FileNotFoundException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Scanner;

// To jest przykład tzw. klasy narzędziowej (utility class),
// w której są zdefiniowane różne funkcje - w formie metod statycznych.

public class ObslugaCSV {

	public static List<Employee> wczytaj(File plik) {
		List<Employee> lista = Collections.synchronizedList(new ArrayList<>());
		try (Scanner scanner = new Scanner(plik)) {
			scanner.nextLine();
			while(scanner.hasNextLine()) {
				String linia = scanner.nextLine();
				String[] t = linia.split(";", 11);
				
				Employee emp = new Employee(Integer.parseInt(t[0]),
						t[1], t[2], t[3], Double.parseDouble(t[4]), LocalDate.parse(t[5]),
						t[6], t[7], t[8], t[9], t[10]);
				lista.add(emp);
			}
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		}
		
		return lista;
	}
	
	public static List<Employee> wczytaj(String sciezka) {
		return wczytaj(new File(sciezka));
	}
}
