package kalkulator;

import java.io.IOException;
import java.io.PrintWriter;

import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@WebServlet("/Kalkulator2")
public class Kalkulator2 extends HttpServlet {
	private static final long serialVersionUID = 1L;

	// doGet wykona się po raz pierwszy, gdy wejdziemy pod adres Kalkulator2
	// i wyświetli pusty formularz (wtedy parametry są nullami i nie wchodzimy do ifa)
	// i wykona się po raz drugi po naciśnięciu guzika Oblicz i wysłaniu zapytania z parametrami
	// - wtedy już wejdziemy do if-a i wyświetlimy wynik
	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		response.setContentType("text/html");
		response.setCharacterEncoding("utf-8");
		PrintWriter out = response.getWriter();
		
		out.println("<!DOCTYPE html>");
		out.println("<html>");
		out.println("<head>");
		out.println("<title>Kalkulator serwletowy</title>");
		out.println("<link rel='stylesheet' type='text/css' href='styl.css'>");
		out.println("</head>");
		out.println("<body>");
		out.println("<h1>Kalkulator 2</h1>");
		out.println("<p>Wpisz liczby i wybierz działanie:</p>");		
		out.println("<form>");
		out.println("<input name='liczba1' type='number'>");
		out.println("<select name='operacja'>");
		out.println("<option value='+'>+</option>");
		out.println("<option value='-'>-</option>");
		out.println("<option value='*'>*</option>");
		out.println("<option value='/'>/</option>");
		out.println("</select>");		
		out.println("<input name='liczba2' type='number'>");
		out.println("<button>=</button>");
		out.println("</form>");
		
		String param1 = request.getParameter("liczba1");
		String param2 = request.getParameter("liczba2");
		String operacja = request.getParameter("operacja");
		
		if(param1 != null && param2 != null && operacja != null) {
			try {
				long liczba1 = Long.parseLong(param1);
				long liczba2 = Long.parseLong(param2);
				long wynik = switch(operacja) {
					case "+" -> liczba1 + liczba2;
					case "-" -> liczba1 - liczba2;
					case "*" -> liczba1 * liczba2;
					case "/" -> liczba1 / liczba2;
					default -> throw new IllegalArgumentException("Nieznane działanie: " + operacja);
				};
				out.printf("<div class='wynik'>%d %s %d = <strong>%d</strong></div>\n",
						liczba1, operacja, liczba2, wynik);
			} catch (NumberFormatException e) {
				out.printf("<div class='error'>Niepoprawny format liczby</div>\n");
			} catch(Exception e) {
				out.printf("<div class='error'>Błąd: %s</div>\n", e.getMessage());				
			}
		}
		out.println("</body>");
		out.println("</html>");
	}

}
