package zajecia.postgresql;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import javax.swing.JOptionPane;

/* Ta wersja dokonuje filtrowania po stronie bazy danych (WHERE)
 * a parametr do zapytania przekazuje we właściwy sposób, za pomocą ? i setString
 * Ta wersja jest poprawna: wydajna i bezpieczna.
 */

public class OdczytajWybranych_v3_Parametry {

	public static void main(String[] args) {
		String szukanyJob = JOptionPane.showInputDialog("Podaj kod stanowiska, np. IT_PROG");
		// TODO wypisz tych pracowników, którzy mają taki job_id

		try(Connection c = DriverManager.getConnection("jdbc:postgresql://localhost:5432/hr", "kurs", "abc123");
			PreparedStatement stmt = c.prepareStatement("SELECT * FROM employees WHERE job_id = ?")) {
			
			/* W treści zapytania miejsca na parametry oznaczamy znakami ?
			 * a następnie na obiekcie PreparedStatement ustawiamy wartości parametrów
			 * za pomocą setString, setInt itd.
			 * Numer parametru to numer znaku zapytania liczony od 1.
			 */
			stmt.setString(1, szukanyJob);
			
			System.out.println("Za chwilę wykonam: " + stmt + "\n");
			
			try(ResultSet rs = stmt.executeQuery()) {
				while(rs.next()) {
					int id = rs.getInt("employee_id");
					String firstName = rs.getString("first_name");
					String lastName = rs.getString("last_name");
					String jobId = rs.getString("job_id");
					BigDecimal salary = rs.getBigDecimal("salary");
					System.out.println("Pracownik nr " + id + ": " + firstName + " " + lastName + " (" + jobId + ") zarabia " + salary);
				}
			}
		} catch (SQLException e) {
			e.printStackTrace();
		}
	}

}
