package zajecia.postgresql;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

// JDBC - Java Database Connectivity
// Podstawowy sposób łączenia się z SQL-owymi bazami danych w Javie.
// Umożliwia i wymaga pisania bezpośrednio komend SQL do wykonania.
// Daje ujednolicony interfejs programistyczny niezależny od rodzaju bazy danych.
// W Javie używa się głównie interfejsów, ale do projektu trzeba dodać STEROWNIK
// obsługujący konkretny rodzaj bazy danych - zawiera on implementacje tych interfejsów.
public class Odczyt1 {

	public static void main(String[] args) {
		try {
			// Koncepcyjnie rzecz biorąc tworzymy obiekt takiej klasy:
			// org.postgresql.jdbc.PgConnection c = new org.postgresql.jdbc.PgConnection(null, null, "jdbc:postgresql://localhost:5432/hr");
			
			// Ale zapisuje się to w ten sposób, za pomocą klas i interfejsów, które są częścią ogólnego API JDBC
			Connection c = DriverManager.getConnection("jdbc:postgresql://localhost:5432/hr", "kurs", "abc123");
			System.out.println("Udało się połączyć, c = " + c);
			
			// Statement to obiekt służący do wykonywania poleceń SQL.
			Statement stmt = c.createStatement();
			
			// execute - ogólne wykonanie jakiegoś kodu SQL
			// executeQuery - wykonanie zapytania, które zwraca wynik, w praktyce: SELECT
			ResultSet rs = stmt.executeQuery("SELECT * FROM employees");
			System.out.println("Mam wyniki: " + rs);
			System.out.println();
			
			// ResultSet daje dostęp do wyników. Zgodnie z teorią SQL jest to "kursor", który pozwala przejrzeć wyniki.
			// Jeśli chcemy odczytać wszystkie wiersze wynikowe, to typym zapisem jest taka pętla:
			// rs.next() - próbuje przejść do nast wiersza i zwraca true, jeśli się udało, a false jeśli to już koniec danych
			while(rs.next()) {
				// w obrębie pętli za pomocą rs.getTYPDANYCH(KOLUMNA) odczytujemy wartości poszczególnych pól
				// Można podać numer kolumny licząc od 1, albo nazwę.
				int id = rs.getInt(1);
				String firstName = rs.getString(2);
				String lastName = rs.getString(3);
				
				BigDecimal salary = rs.getBigDecimal("salary");
				
				System.out.println("Pracownik nr " + id + ": " + firstName + " " + lastName + " zarabia " + salary);
			}
			// Połączenie należy zamknąć, ale "zamykalne" są też obiekty Statement i ResultSet.
			// Prawidłowo zamykając wszystkie te obiekty możemy poprawić wydajność całej bazy danych.
		
			rs.close();
			stmt.close();
			c.close();
		} catch (SQLException e) {
			e.printStackTrace();
		}
	}

}
