package pracownicy;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class P7_Sortowanie_v1 {

	public static void main(String[] args) {
		List<Employee> emps = ObslugaCSV.wczytaj("pracownicy.csv");
		// W tej wersji użyję wyłącznie technik dostępnych w starszych wersjach Javy, przed Java 8.
		
		Collections.sort(emps, new Comparator<Employee>() {
			public int compare(Employee emp1, Employee emp2) {
				// metoda compare ma zwrócić wartość ujemną, jesli emp1 jest "mniejszy"
				// wartość dodatnią jeśli emp1 jest "większy" od emp2
				// zero jeśli oba są równe
				// Tutaj wystarczy odjąć od siebie pensje pracowników
				return emp2.getSalary() - emp1.getSalary();
			}
		});
		
		for (Employee emp : emps) {
			System.out.printf("%s %s (%s) zarabia %d\n",
					emp.getFirstName(), emp.getLastName(), emp.getJobTitle(), emp.getSalary());
		}
	}

}
