package pracownicy;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;

public class ObslugaCSV {
	private static final String SEP = ";";

	// Gdy w jednej klasie mamy dwie metody o tej samej nazwie różniące się typem parametru,
	// to nazywa się to "przeciążanie" / "overloading"
	public static List<Employee> wczytaj(String sciezka) {
		return wczytaj(new File(sciezka));
	}
	
	public static List<Employee> wczytaj(File plik) {
		List<Employee> emps = new ArrayList<>();
		try(Scanner scanner = new Scanner(plik)) {
			while(scanner.hasNextLine()) {
				String linia = scanner.nextLine();
				String[] t = linia.split(SEP, 11);
				Employee emp = new Employee(Integer.parseInt(t[0]),
						t[1], t[2], t[3], Integer.parseInt(t[4]), LocalDate.parse(t[5]),
						t[6], t[7], t[8], t[9], t[10]);
				emps.add(emp);
			}
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		}
		return emps;
	}
	
	public static void zapisz(List<Employee> emps, String sciezka) {
		zapisz(emps, new File(sciezka));
	}
	
	public static void zapisz(List<Employee> emps, File plik) {
		try(PrintWriter out = new PrintWriter(plik)) {
			for (Employee emp : emps) {
				out.print(emp.getId());
				out.print(SEP);
				out.print(emp.getFirstName());
				out.print(SEP);
				out.print(emp.getLastName());
				out.print(SEP);
				out.print(emp.getJobTitle());
				out.print(SEP);
				out.print(emp.getSalary());
				out.print(SEP);
				out.print(emp.getHireDate());
				out.print(SEP);
				out.print(emp.getDepartmentName());
				out.print(SEP);
				out.print(emp.getStreetAddress());
				out.print(SEP);
				out.print(emp.getPostalCode());
				out.print(SEP);
				out.print(emp.getCity());
				out.print(SEP);
				out.print(emp.getCountry());
				out.println();
			}
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		}
	}

}
