package pracownicy;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class Grupowanie6 {

	public static void main(String[] args) {
		final List<Employee> emps = ObslugaCSV.wczytaj("pracownicy.csv");
		
		// W tej wersji w słowniku jako wartość będziemy pamiętać 2-el. tablicę
		// na pozycji 0 - ilość, na pozycji 1 - suma pensji
		final Map<String, int[]> mapa = new TreeMap<>();		
		
		for (Employee emp : emps) {
			final String jobTitle = emp.getJobTitle();
			if (mapa.containsKey(jobTitle)) {
				int[] t = mapa.get(jobTitle);
				t[0] += 1;
				t[1] += emp.getSalary();
				// Uwaga! Nie trzeba tej tablicy zapisywać w mapie,
				// bo pobraliśmy referencję do tego samego obiektu, który jest przechowywany w mapie.
			} else {
				mapa.put(emp.getJobTitle(), new int[] {1, emp.getSalary()});
			}
		}
		
		// Aby przejrzeć zawartość słownika, klucze wraz z wartościami, używa się entrySet.
		for (Map.Entry<String, int[]> entry : mapa.entrySet()) {
			String job = entry.getKey();
			int ilosc = entry.getValue()[0];
			int suma = entry.getValue()[1];
			double srednia = 1.0 * suma / ilosc;
			System.out.printf("|%32s | %2d | %8.2f |\n", job, ilosc, srednia);
		}
	}

}
