package alx.p36_lokalizacja;

import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class UseLocale3_Builder {

	public static void main(String[] args) {
		Locale polski1 = new Locale.Builder().setLanguage("pl").build();
		Locale.Builder builder = new Locale.Builder();
		
		builder.setLanguage("pl");
		Locale polski = builder.build();

		builder.clear();
		builder.setLanguage("ru").setRegion("RU").setScript("Cyrl");
		Locale rosyjski = builder.build();
		
		DateFormat dfPL = DateFormat.getDateInstance(DateFormat.FULL, polski);
		DateFormat dfRU = DateFormat.getDateInstance(DateFormat.FULL, rosyjski);
		
		Date now = Calendar.getInstance().getTime();
		
		System.out.println(dfPL.format(now));
		System.out.println(dfRU.format(now));
	}

}
