package emps.obiektowo;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;

// Klasa narzędziowa ("utility class") zawierająca operacje wczytywania i zapisywania danych pracowników z/do pliku CSV.
public class ObslugaCSV {
	private static final String NAGLOWEK = "employee_id;first_name;last_name;job_title;salary;hire_date;department_name;address;postal_code;city;country";
	private static final String SEP = ";";
	
	// Aby uniemożliwić innym programistom tworzenie obiektów tej klasy (bo wszystko jest tu statyczne i tworzenie obiektów nie ma sensu)
	// można umieścić tu prywatny konstruktor domyślny - wtedy nikt go nie wywoła.
	private ObslugaCSV() {
		
	}

	public static List<Employee> wczytaj(File plik) {
		List<Employee> emps = new ArrayList<>();
		try(Scanner scanner = new Scanner(plik)) {
			scanner.nextLine();
			
			while(scanner.hasNextLine()) {
				String linia = scanner.nextLine();
				String[] t = linia.split(SEP, 11);
				Employee emp = new Employee(Integer.parseInt(t[0]), t[1], t[2], t[3],
						Integer.parseInt(t[4]), LocalDate.parse(t[5]), t[6], t[7], t[8], t[9], t[10]);
				
				emps.add(emp);
			}
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		}
		
		return emps;
	}
	
	public static List<Employee> wczytaj(String sciezka) {
		return wczytaj(new File(sciezka));
	}
	
	public static void zapisz(List<Employee> lista, File plik) {
		try(PrintWriter out = new PrintWriter(plik)) {
			out.println(NAGLOWEK);
			for (Employee emp : lista) {
				out.print(emp.getEmployeeId());
				out.print(SEP);
				out.print(emp.getFirstName());
				out.print(SEP);
				out.print(emp.getLastName());
				out.print(SEP);
				out.print(emp.getJobTitle());
				out.print(SEP);
				out.print(emp.getSalary());
				out.print(SEP);
				out.print(emp.getHireDate());
				out.print(SEP);
				out.print(emp.getDepartmentName());
				out.print(SEP);
				out.print(emp.getStreetAddress());
				out.print(SEP);
				out.print(emp.getPostalCode());
				out.print(SEP);
				out.print(emp.getCity());
				out.print(SEP);
				out.print(emp.getCountry());
				out.println();
			}
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		}
	}

	public static void zapisz(List<Employee> lista, String sciezka) {
		zapisz(lista, new File(sciezka));
	}
}
