package com.example.demo;

import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping("/kalkulator-podstawowy")
public class KalkulatorPodstawowy {
	// W tej wersji obliczenie było realizowane w samej metodzie kontrolera.
	// W większej skali byłoby to niewłaściwe podejście - mieszanie warstwy webowej (kontroler też do niej należy)
	// z logiką aplikacji.

	@GetMapping
	public String kalkulatorGet() {
		return "kalkulator.html";
	}
	
	// Spring automatycznie przekaże parametry zapytania (dane z formularza)
	// do tej metody - wystarczy zadeklarować parametry o tej samej nazwie.
	@PostMapping
	public String kalkulatorPost(Model model, Long liczba1, Long liczba2, String operacja) {
		long wynik = switch(operacja) {
			case "+" -> liczba1 + liczba2;
			case "-" -> liczba1 - liczba2;
			case "*" -> liczba1 * liczba2;
			case "/" -> liczba1 / liczba2;
			case "%" -> liczba1 % liczba2;
			default  -> 0;
		};
		model.addAttribute("wynik", wynik);
		return "kalkulator.html";
	}
}
