package sklep.web;

import java.io.IOException;

import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import sklep.basket.Basket;
import sklep.db.DBConnection;
import sklep.db.ProductDAO;
import sklep.model.Product;

@WebServlet("/AddToBasket")
public class AddToBasket extends HttpServlet {
	private static final long serialVersionUID = 1L;

	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		try {
			int id = Integer.parseInt(request.getParameter("productId"));
			try(DBConnection db = DBConnection.open()) {
				ProductDAO productDAO = db.productDAO();
				Product product = productDAO.findById(id);
				
				// Zamiast HttpSession można by użyć ServletContext,
				// ale wtedy mielibyśmy efekt "globalnego" koszyka.
				// ServletContext servletContext = this.getServletContext();
				
				// Sesja jest skojarzona z konkretnym klientem, działa to dzięki ciasteczkom.
				// Dzięki obecności Listenera mogę założyć, że koszyk jest obecny w sesji.
				HttpSession session = request.getSession();
				Basket basket = (Basket) session.getAttribute("basket");
				basket.addProduct(product);
			}
		} catch(Exception e) {
			// ignorujemy błędy
		}
		
		// Przekierowanie - każemy przeglądarce wejść pod ten adres.
		response.sendRedirect("products8.jsp");
	}

}
