package hello;

import java.io.IOException;
import java.io.PrintWriter;
import java.time.LocalTime;

import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@WebServlet("/Hello")
public class Hello extends HttpServlet {
	private static final long serialVersionUID = 1L;

	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		/* Serwer (np. WildFly, Tomcat ...) wywołuje naszą metodę doGet gdy na serwer przyjdzie zapytanie pod określony adres.
		 * Serwer przekazuje nam dwa parametry:
		 * request - zgromadzone informacje o zapytaniu
		 * response - obiekt, za pomocą którego mamy utworzyć odpowiedź.
		 * 
		 * Gdy chcemy wysłać odp. tekstową, to postępujemy tak:
		 */

		// response.setContentType("text/html");
		response.setContentType("text/plain");
		response.setCharacterEncoding("UTF-8");
		PrintWriter out = response.getWriter();
		out.println("Hello world!");
		out.println("Teraz jest godzina " + LocalTime.now());
		out.println("<strong style='color:red'>Próba zażądania formatowania HTML</strong>");
	}

}
