package pracownicy;

import java.util.List;
import java.util.Set;
import java.util.TreeSet;

// Schemat grupowania w oparciu o "pętlę w pętli".
// Nie jest to optymalne rzwiązanie pod względem wydajności.
// Gdy mamy 107 pracowników i 19 stanowisk, to pętla for i if w linii 28 wykonają się 107*19 razy.
// Da się to zrobić sprytniej / szybciej - zobaczymy w kolejnych wersjach.
public class Grupowanie1 {

	public static void main(String[] args) {
		List<Employee> emps = ObslugaCSV.wczytaj("pracownicy.csv");
		
		// etap 1 - zebrać zbiór jobsów bez powtórzeń
		Set<String> jobs = new TreeSet<>();
		for (Employee emp : emps) {
			jobs.add(emp.getJobTitle());
		}

		// etap 2 - dla każdego joba obliczyć wynik podonie jak w przykładach 4 i 5
		for(String job : jobs) {
			double suma = 0;
			int ilosc = 0;
			
			for (Employee emp : emps) {
				if (job.equals(emp.getJobTitle())) {
					suma += emp.getSalary();
					ilosc++;
				}
			}
			double srednia = suma / ilosc;
			System.out.printf("|%32s | %2d | %8.2f |\n", job, ilosc, srednia);
		}
	}

}
