package emps.strumieniowo;

import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

import javax.swing.JOptionPane;

public class P5_MinMax_v3 {

	// W tej wersji użytkownik podaje nazwę miasta, a program znajduje pracownika, który zarabia nawięcej w tym mieście.
	
	public static void main(String[] args) {
		String city = JOptionPane.showInputDialog("Podaj nawę miasta");
		
		List<Employee> emps = ObslugaCSV.wczytaj("emps.csv");
		
		Optional<Employee> max = emps.stream()
				.filter(emp -> Objects.equals(emp.getCity(), city))
				.max(Comparator.comparingInt(Employee::getSalary));

		if(max.isPresent()) {
			JOptionPane.showMessageDialog(null, "W mieście " + city + " najbogatszy jest "
						+ max.get().getFirstName() + " " + max.get().getLastName() + " z pensją " + max.get().getSalary());
		} else {
			JOptionPane.showMessageDialog(null, "Nikt nie pracuje w mieście " + city);
		}
		
	}

}
