package emps.obiektowo;

import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.IntSummaryStatistics;
import java.util.List;
import java.util.Locale;

import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSpinner;
import javax.swing.SpringLayout;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.SpinnerNumberModel;

public class PodwyzkaOkno {
	private JFrame frame;
	private List<Employee> emps = List.of();
	private JLabel lblLiczba;
	private JLabel lblSrednia;
	private JLabel lblLiczbaJob;
	private JLabel lblSredniaJob;
	private JComboBox<String> comboBox;
	private JSpinner spinner;

	/**
	 * Launch the application.
	 */
	public static void main(String[] args) {
		EventQueue.invokeLater(new Runnable() {
			public void run() {
				try {
					PodwyzkaOkno window = new PodwyzkaOkno();
					window.frame.setVisible(true);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});
	}

	/**
	 * Create the application.
	 */
	public PodwyzkaOkno() {
		initialize();
	}

	/**
	 * Initialize the contents of the frame.
	 */
	private void initialize() {
		frame = new JFrame();
		frame.setBounds(100, 100, 783, 640);
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		SpringLayout springLayout = new SpringLayout();
		frame.getContentPane().setLayout(springLayout);
		
		JButton btnWczytajPlik = new JButton("Wczytaj plik");
		btnWczytajPlik.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				wczytajDane();
			}
		});
		btnWczytajPlik.setFont(new Font("Dialog", Font.BOLD, 24));
		springLayout.putConstraint(SpringLayout.NORTH, btnWczytajPlik, 10, SpringLayout.NORTH, frame.getContentPane());
		springLayout.putConstraint(SpringLayout.WEST, btnWczytajPlik, 10, SpringLayout.WEST, frame.getContentPane());
		springLayout.putConstraint(SpringLayout.SOUTH, btnWczytajPlik, 103, SpringLayout.NORTH, frame.getContentPane());
		springLayout.putConstraint(SpringLayout.EAST, btnWczytajPlik, 378, SpringLayout.WEST, frame.getContentPane());
		frame.getContentPane().add(btnWczytajPlik);
		
		JButton btnZapiszPlik = new JButton("Zapisz plik");
		btnZapiszPlik.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				zapiszDane();
			}
		});
		btnZapiszPlik.setFont(new Font("Dialog", Font.BOLD, 24));
		springLayout.putConstraint(SpringLayout.NORTH, btnZapiszPlik, 10, SpringLayout.NORTH, frame.getContentPane());
		springLayout.putConstraint(SpringLayout.WEST, btnZapiszPlik, -363, SpringLayout.EAST, frame.getContentPane());
		springLayout.putConstraint(SpringLayout.SOUTH, btnZapiszPlik, 0, SpringLayout.SOUTH, btnWczytajPlik);
		springLayout.putConstraint(SpringLayout.EAST, btnZapiszPlik, -10, SpringLayout.EAST, frame.getContentPane());
		frame.getContentPane().add(btnZapiszPlik);
		
		JLabel lblLiczbaPracownikw = new JLabel("Liczba pracowników:");
		lblLiczbaPracownikw.setFont(new Font("Dialog", Font.BOLD, 24));
		springLayout.putConstraint(SpringLayout.NORTH, lblLiczbaPracownikw, 38, SpringLayout.SOUTH, btnWczytajPlik);
		springLayout.putConstraint(SpringLayout.WEST, lblLiczbaPracownikw, 0, SpringLayout.WEST, btnWczytajPlik);
		springLayout.putConstraint(SpringLayout.SOUTH, lblLiczbaPracownikw, 81, SpringLayout.SOUTH, btnWczytajPlik);
		springLayout.putConstraint(SpringLayout.EAST, lblLiczbaPracownikw, 0, SpringLayout.EAST, btnWczytajPlik);
		frame.getContentPane().add(lblLiczbaPracownikw);
		
		lblLiczba = new JLabel("liczba");
		lblLiczba.setFont(new Font("Dialog", Font.BOLD, 24));
		springLayout.putConstraint(SpringLayout.NORTH, lblLiczba, 38, SpringLayout.SOUTH, btnZapiszPlik);
		springLayout.putConstraint(SpringLayout.WEST, lblLiczba, 0, SpringLayout.WEST, btnZapiszPlik);
		springLayout.putConstraint(SpringLayout.SOUTH, lblLiczba, 0, SpringLayout.SOUTH, lblLiczbaPracownikw);
		springLayout.putConstraint(SpringLayout.EAST, lblLiczba, 0, SpringLayout.EAST, btnZapiszPlik);
		frame.getContentPane().add(lblLiczba);
		
		JLabel lblredniaPensja = new JLabel("Średnia pensja:");
		springLayout.putConstraint(SpringLayout.NORTH, lblredniaPensja, 21, SpringLayout.SOUTH, lblLiczbaPracownikw);
		springLayout.putConstraint(SpringLayout.WEST, lblredniaPensja, 0, SpringLayout.WEST, btnWczytajPlik);
		springLayout.putConstraint(SpringLayout.EAST, lblredniaPensja, 0, SpringLayout.EAST, btnWczytajPlik);
		lblredniaPensja.setFont(new Font("Dialog", Font.BOLD, 24));
		frame.getContentPane().add(lblredniaPensja);
		
		lblSrednia = new JLabel("srednia");
		lblSrednia.setFont(new Font("Dialog", Font.BOLD, 24));
		springLayout.putConstraint(SpringLayout.NORTH, lblSrednia, 21, SpringLayout.SOUTH, lblLiczba);
		springLayout.putConstraint(SpringLayout.WEST, lblSrednia, 0, SpringLayout.WEST, btnZapiszPlik);
		frame.getContentPane().add(lblSrednia);
		
		JLabel lblWybierzStanowisko = new JLabel("Wybierz stanowisko:");
		springLayout.putConstraint(SpringLayout.NORTH, lblWybierzStanowisko, 33, SpringLayout.SOUTH, lblredniaPensja);
		lblWybierzStanowisko.setFont(new Font("Dialog", Font.BOLD, 24));
		springLayout.putConstraint(SpringLayout.WEST, lblWybierzStanowisko, 0, SpringLayout.WEST, btnWczytajPlik);
		springLayout.putConstraint(SpringLayout.EAST, lblWybierzStanowisko, 0, SpringLayout.EAST, btnWczytajPlik);
		frame.getContentPane().add(lblWybierzStanowisko);
		
		comboBox = new JComboBox<>();
		comboBox.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				zaktualizujDaneStanowiska();
			}
		});
		springLayout.putConstraint(SpringLayout.SOUTH, lblWybierzStanowisko, -26, SpringLayout.NORTH, comboBox);
		springLayout.putConstraint(SpringLayout.NORTH, comboBox, 308, SpringLayout.NORTH, frame.getContentPane());
		comboBox.setFont(new Font("Dialog", Font.BOLD, 24));
		springLayout.putConstraint(SpringLayout.WEST, comboBox, 0, SpringLayout.WEST, btnWczytajPlik);
		springLayout.putConstraint(SpringLayout.EAST, comboBox, 0, SpringLayout.EAST, btnWczytajPlik);
		frame.getContentPane().add(comboBox);
		
		JLabel lblLiczbaTakichPracownikw = new JLabel("Liczba takich pracowników:");
		lblLiczbaTakichPracownikw.setFont(new Font("Dialog", Font.BOLD, 24));
		springLayout.putConstraint(SpringLayout.NORTH, lblLiczbaTakichPracownikw, 36, SpringLayout.SOUTH, comboBox);
		springLayout.putConstraint(SpringLayout.WEST, lblLiczbaTakichPracownikw, 0, SpringLayout.WEST, btnWczytajPlik);
		springLayout.putConstraint(SpringLayout.EAST, lblLiczbaTakichPracownikw, 0, SpringLayout.EAST, btnWczytajPlik);
		frame.getContentPane().add(lblLiczbaTakichPracownikw);
		
		lblLiczbaJob = new JLabel("liczba");
		springLayout.putConstraint(SpringLayout.NORTH, lblLiczbaJob, 9, SpringLayout.NORTH, lblLiczbaTakichPracownikw);
		springLayout.putConstraint(SpringLayout.WEST, lblLiczbaJob, 0, SpringLayout.WEST, btnZapiszPlik);
		springLayout.putConstraint(SpringLayout.EAST, lblLiczbaJob, -10, SpringLayout.EAST, frame.getContentPane());
		lblLiczbaJob.setFont(new Font("Dialog", Font.BOLD, 24));
		frame.getContentPane().add(lblLiczbaJob);
		
		JLabel lblredniaPensja_1 = new JLabel("Średnia pensja:");
		lblredniaPensja_1.setFont(new Font("Dialog", Font.BOLD, 24));
		springLayout.putConstraint(SpringLayout.NORTH, lblredniaPensja_1, 22, SpringLayout.SOUTH, lblLiczbaTakichPracownikw);
		springLayout.putConstraint(SpringLayout.WEST, lblredniaPensja_1, 10, SpringLayout.WEST, frame.getContentPane());
		springLayout.putConstraint(SpringLayout.EAST, lblredniaPensja_1, 0, SpringLayout.EAST, btnWczytajPlik);
		frame.getContentPane().add(lblredniaPensja_1);
		
		lblSredniaJob = new JLabel("srednia");
		lblSredniaJob.setFont(new Font("Dialog", Font.BOLD, 24));
		springLayout.putConstraint(SpringLayout.NORTH, lblSredniaJob, 0, SpringLayout.NORTH, lblredniaPensja_1);
		springLayout.putConstraint(SpringLayout.EAST, lblSredniaJob, 0, SpringLayout.EAST, lblSrednia);
		frame.getContentPane().add(lblSredniaJob);
		
		JLabel lblKwotaPodwyki = new JLabel("Kwota podwyżki");
		lblKwotaPodwyki.setFont(new Font("Dialog", Font.BOLD, 24));
		springLayout.putConstraint(SpringLayout.NORTH, lblKwotaPodwyki, 26, SpringLayout.SOUTH, lblredniaPensja_1);
		springLayout.putConstraint(SpringLayout.WEST, lblKwotaPodwyki, 10, SpringLayout.WEST, frame.getContentPane());
		springLayout.putConstraint(SpringLayout.SOUTH, lblKwotaPodwyki, 41, SpringLayout.SOUTH, lblredniaPensja_1);
		springLayout.putConstraint(SpringLayout.EAST, lblKwotaPodwyki, 204, SpringLayout.WEST, frame.getContentPane());
		frame.getContentPane().add(lblKwotaPodwyki);
		
		spinner = new JSpinner();
		spinner.setModel(new SpinnerNumberModel(Integer.valueOf(0), null, null, Integer.valueOf(1)));
		spinner.setFont(new Font("Dialog", Font.BOLD, 24));
		springLayout.putConstraint(SpringLayout.NORTH, spinner, 21, SpringLayout.SOUTH, lblSredniaJob);
		springLayout.putConstraint(SpringLayout.WEST, spinner, 0, SpringLayout.WEST, btnZapiszPlik);
		springLayout.putConstraint(SpringLayout.EAST, spinner, 0, SpringLayout.EAST, btnZapiszPlik);
		frame.getContentPane().add(spinner);
		
		JButton btnZastosujPodwyk = new JButton("Zastosuj podwyżkę");
		btnZastosujPodwyk.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				zastosujPodwyzke();
			}
		});
		btnZastosujPodwyk.setFont(new Font("Dialog", Font.BOLD, 24));
		springLayout.putConstraint(SpringLayout.NORTH, btnZastosujPodwyk, 19, SpringLayout.SOUTH, lblKwotaPodwyki);
		springLayout.putConstraint(SpringLayout.WEST, btnZastosujPodwyk, 10, SpringLayout.WEST, frame.getContentPane());
		springLayout.putConstraint(SpringLayout.SOUTH, btnZastosujPodwyk, 72, SpringLayout.SOUTH, lblKwotaPodwyki);
		springLayout.putConstraint(SpringLayout.EAST, btnZastosujPodwyk, 0, SpringLayout.EAST, btnWczytajPlik);
		frame.getContentPane().add(btnZastosujPodwyk);
	}

	private void wczytajDane() {
		JFileChooser chooser = new JFileChooser(".");
		chooser.setDialogTitle("Wybierz plik");
		chooser.setFileFilter(new FileNameExtensionFilter("Pliki CSV", "csv", "txt"));
		int coSieStalo = chooser.showOpenDialog(null);
		if(coSieStalo != JFileChooser.APPROVE_OPTION) {
			return;
		}
		File wybranyPlik = chooser.getSelectedFile();
		emps  = ObslugaCSV.wczytaj(wybranyPlik);
		zaktualizujDaneGlobalne();
		zaktualizujListeJobow();
	}

	private void zapiszDane() {
		JFileChooser chooser = new JFileChooser(".");
		chooser.setDialogTitle("Wybierz plik");
		chooser.setFileFilter(new FileNameExtensionFilter("Pliki CSV", "csv", "txt"));
		int coSieStalo = chooser.showSaveDialog(null);
		if(coSieStalo != JFileChooser.APPROVE_OPTION) {
			return;
		}
		File wybranyPlik = chooser.getSelectedFile();
		if(wybranyPlik.exists()) {
			int wybor = JOptionPane.showConfirmDialog(frame, "Plik istnieje.\nCzy chcesz go nadpisać?", "Uwaga", JOptionPane.YES_NO_OPTION, JOptionPane.WARNING_MESSAGE);
			if(wybor == JOptionPane.NO_OPTION) {
				return; // nie zapisujemy
			}
		}
		ObslugaCSV.zapisz(emps, wybranyPlik);
	}

	private void zaktualizujDaneGlobalne() {
		// Do pola z liczbą pracowników wpiszemy rozmiar listy:
		lblLiczba.setText(String.valueOf(emps.size()));
		
		double srednia = emps.stream().mapToInt(Employee::getSalary).average().orElse(0);
		lblSrednia.setText(String.format(Locale.US, "%.2f", srednia));
	}
	
	private void zaktualizujListeJobow() {
		String[] jobs = emps.stream().map(Employee::getJobTitle).distinct().sorted().toArray(String[]::new);
		comboBox.setModel(new DefaultComboBoxModel<>(jobs));
	}

	private void zaktualizujDaneStanowiska() {
		String job = (String)comboBox.getSelectedItem();
		IntSummaryStatistics stats = emps.stream()
			.filter(emp -> emp.getJobTitle().equals(job))
			.mapToInt(Employee::getSalary)
			.summaryStatistics();
		lblLiczbaJob.setText(String.valueOf(stats.getCount()));
		lblSredniaJob.setText(String.format(Locale.US, "%.2f", stats.getAverage()));
	}
	
	protected void zastosujPodwyzke() {
		String job = (String)comboBox.getSelectedItem();
		int zmiana = (Integer)spinner.getValue();
		for (Employee emp : emps) {
			if(emp.getJobTitle().equals(job)) {
				emp.setSalary(emp.getSalary() + zmiana);
			}
		}
		zaktualizujDaneStanowiska();
		zaktualizujDaneGlobalne();
	}


}






