package emps.obiektowo;

import java.util.Comparator;
import java.util.List;

// Program wypsiuje pracowników w kolejności posortowanej zwn pensje.

public class P7c_Sortowanie {

	public static void main(String[] args) {
		List<Employee> emps = ObslugaCSV.wczytaj("emps.csv");
		
		// W tej wersji comparator tworzymy za pomocą metody statycznej comparingInt,
		// jako parametr podaje się "wskazanie metody" (method reference), za pomocą której jest odczytywana pensja pracownika.
		
		// Nieformalnie:
		// sortujemy listę stosując sposób porównywania operaty o porównywanie intów,
		// a te inty są pobierane z obiektów Employee za pomocą metody getSalary
		// emps.sort(Comparator.comparingInt(Employee::getSalary));
		emps.sort(Comparator.comparingInt(Employee::getSalary).reversed());
		
		for(Employee emp : emps) {
			System.out.println(emp.getFirstName() + " " + emp.getLastName() + ", zarobki: " + emp.getSalary());
		}
	}

}
