package emps.obiektowo;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Grupowanie3 {
	// Tutaj używamy getOrDefault i nie musimy pisać ifa
	
	public static void main(String[] args) {
		List<Employee> emps = ObslugaCSV.wczytaj("emps.csv");
		
		Map<String, Integer> sumy = new HashMap<>();
		Map<String, Integer> ilosci = new HashMap<>();
		
		for(Employee emp : emps) {
			int suma = sumy.getOrDefault(emp.getJobTitle(), 0);
			sumy.put(emp.getJobTitle(), suma + emp.getSalary());
			int ilosc = ilosci.getOrDefault(emp.getJobTitle(), 0);
			ilosci.put(emp.getJobTitle(), ilosc+1);
		}
		
		for(String job : sumy.keySet()) {
			int suma = sumy.get(job);
			int ile = ilosci.get(job);
			double srednia = (double)suma / ile;
			System.out.printf("| %-32s | %2d | %8.2f |\n", job, ile, srednia);
		}
	}
}
