package emps.obiektowo;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Grupowanie2a {
	// W tej wersji widzimy klasyczny schemat grupowania za pomocą słowników - algorytm, który warto znać.
	// Używamy wyłącznie podstawowych metod get, put i containsKey.
	// W kolejnych wersjach zobaczymy skrócone zapisy z wykorzystaniem nowych metod od Javy 8.
	
	public static void main(String[] args) {
		final List<Employee> emps = ObslugaCSV.wczytaj("emps.csv");
		final Map<String, Integer> sumy = new HashMap<>();
		final Map<String, Integer> ilosci = new HashMap<>();
		
		for(Employee emp : emps) {
			final String jobTitle = emp.getJobTitle();
			if(sumy.containsKey(jobTitle)) {
				sumy.put(jobTitle, sumy.get(jobTitle) + emp.getSalary());
				ilosci.put(jobTitle, ilosci.get(jobTitle) + 1);
			} else {
				sumy.put(jobTitle, emp.getSalary());
				ilosci.put(jobTitle, 1);
			}
		}
		
		for(String job : sumy.keySet()) {
			int suma = sumy.get(job);
			int ile = ilosci.get(job);
			double srednia = (double)suma / ile;
			System.out.printf("| %-32s | %2d | %8.2f |\n", job, ile, srednia);
		}
	}
}
