package emps.obiektowo;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Grupowanie2 {
	// W tej wersji widzimy klasyczny schemat grupowania za pomocą słowników - algorytm, który warto znać.
	// Używamy wyłącznie podstawowych metod get, put i containsKey.
	// W kolejnych wersjach zobaczymy skrócone zapisy z wykorzystaniem nowych metod od Javy 8.
	
	public static void main(String[] args) {
		List<Employee> emps = ObslugaCSV.wczytaj("emps.csv");
		
		Map<String, Integer> sumy = new HashMap<>();
		Map<String, Integer> ilosci = new HashMap<>();
		
		for(Employee emp : emps) {
			if(sumy.containsKey(emp.getJobTitle())) {
				// kolejny pracownik z tego stanowiska → do starej sumy trzeba dodać pensję tego pracownika
				int suma = sumy.get(emp.getJobTitle());
				sumy.put(emp.getJobTitle(), suma + emp.getSalary());
				int ilosc = ilosci.get(emp.getJobTitle());
				ilosci.put(emp.getJobTitle(), ilosc+1);
			} else {
				// pierwszy pracownik z tego stanowiska → wpisujemy jego pensję jako pierwszą wartość
				sumy.put(emp.getJobTitle(), emp.getSalary());
				ilosci.put(emp.getJobTitle(), 1);
			}
		}
		
		// System.out.println(sumy);
		
		for(String job : sumy.keySet()) {
			int suma = sumy.get(job);
			int ile = ilosci.get(job);
			double srednia = (double)suma / ile;
			System.out.printf("| %-32s | %2d | %8.2f |\n", job, ile, srednia);
		}
	}
}
