package emps.obiektowo;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Grupowanie1 {
	// Ta wersja jest poprawna pod względem wyników, natomiast nie jest optymalna pod wzgl wydajności.
	// Dla każdego joba przeglądamy całą listę pracowników i ifem sprawdzamy czy pasuje.
	// Dla 19 stanowisk i 107 pracowników koszt wynosi (19+1)*(107)

	public static void main(String[] args) {
		List<Employee> emps = ObslugaCSV.wczytaj("emps.csv");
		
		// etap 1 - zebranie stanowisk bez powtórzeń
		Set<String> jobs = new HashSet<>();
		for(Employee emp : emps) {
			jobs.add(emp.getJobTitle());
		}
		//System.out.println(jobs);
		
		// etap 2 - dla każdego stanowiska z tego zbioru obliczymy średnią
		// przeglądając za każdym razem całą listę pracowników
		for (String job : jobs) {
			int ile = 0;
			int suma = 0;
			for(Employee emp : emps) {
				if(emp.getJobTitle().equals(job)) {
					suma += emp.getSalary();
					ile++;
				}
			}
			double srednia = (double)suma / ile;
			System.out.printf("| %-32s | %2d | %8.2f |\n", job, ile, srednia);
		}
	}
}
