package emps.comparable;

import java.text.Collator;
import java.util.List;

public class Porownywanie {

	public static void main(String[] args) {
		List<Employee> emps = ObslugaCSV.wczytaj("emps.csv");
		
		Employee emp110 = emps.get(10);
		Employee emp120 = emps.get(20);
		
		System.out.println(emp110);
		System.out.println(emp120);
		System.out.println();
		
		// w Javie nie działa porównywanie za pomocą < > rzeczy innych niż liczby
//		if(emp110 < emp120) {
//			System.out.println("110 zarabia mniej");
//		} else if(emp110 > emp120) {
//			System.out.println("110 zarabia więcej");
//		} else {
//			System.out.println("zarabiają tyle samo");
//		}
		
		// zamiast tego, jeśli klasa jest Comparable, to wynik operacji compareTo porównujemy z zerem
		
		if(emp110.compareTo(emp120) < 0) {
			System.out.println("110 zarabia mniej");
		} else if(emp110.compareTo(emp120) > 0) {
			System.out.println("110 zarabia więcej");
		} else {
			System.out.println("zarabiają tyle samo");
		}
		// to samo dla klas takich jak String, BigDecimal, LocalDate
		
		String ala = "Ala";
		String ola = "Ola";
		System.out.println(ala.compareTo(ola));
		if(ala.compareTo(ola) < 0) {
			System.out.println("Ala < Ola");
		}
		System.out.println();
		
		System.out.println("Łukasz".compareTo("Marek")); // >
		
		Collator collator = Collator.getInstance();
		System.out.println(collator.compare("Łukasz", "Marek")); // <
	}

}
