package sklep.model;

import java.io.Serializable;
import java.math.BigDecimal;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

/**
 * The persistent class for the products database table.
 * 
 */

/*
 * Sposób na zapisanie kilku named queries w starszych wersjach Javy (tylko nie wiem jakich ;-) )
 * 
 * @NamedQueries({
 *   @NamedQuery(name="Product.findAll", query="SELECT p FROM Product p"),
 *   @NamedQuery(name="Product.sredniaCena", query="SELECT avg(p.price) FROM Product p"),
 * })
 */

@Entity
@Table(name = "products")
@NamedQuery(name = "Product.findAll", query = "SELECT p FROM Product p")
@NamedQuery(name = "Product.sredniaCena", query = "SELECT avg(p.price) FROM Product p")
public class Product implements Serializable {
	private static final long serialVersionUID = 1L;

// W celu obserwacji powstawania i usuwania obiektów:
//	{ System.out.println("!new Product!"); }
	
//	@Override
//	protected void finalize() {
//		System.out.println("Ginie Produkt nr " + productId);
//	}
// Używanie finalize tak, że miałoby wpływać na działanie, jest niezalecane!
	
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@Column(name = "product_id", insertable = false, updatable = false)
	private Integer productId;

	@Size(max=4000)
	private String description;

	@NotNull
	@DecimalMin("0.01")
	@DecimalMax("99999999.99")
	private BigDecimal price;

	@Column(name = "product_name")
	@NotNull
	@Size(min=2, max=100)
	private String productName;

	@DecimalMin("0.00")
	@DecimalMax("0.99")
	private BigDecimal vat;

	public Product() {
	}

	public Integer getProductId() {
		return this.productId;
	}

	public void setProductId(Integer productId) {
		this.productId = productId;
	}

	public String getDescription() {
		return this.description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public BigDecimal getPrice() {
		return this.price;
	}

	public void setPrice(BigDecimal price) {
		this.price = price;
	}

	public String getProductName() {
		return this.productName;
	}

	public void setProductName(String productName) {
		this.productName = productName;
	}

	public BigDecimal getVat() {
		return this.vat;
	}

	public void setVat(BigDecimal vat) {
		this.vat = vat;
	}

	@Override
	public String toString() {
		return "Product [productId=" + productId + ", description=" + description + ", price=" + price
				+ ", productName=" + productName + ", vat=" + vat + "]";
	}

}