package sklep.controller;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import javax.sql.DataSource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping("/alt1")
public class AlternatywneProdukty1 {
	@Autowired
	private DataSource dataSource;

	// Tutaj użyjemy "zwykłego JDBC", czyli PreparedStatemnt, ResultSet itd...
	// Ale Spring automatycznie wstrzyknie nam (jako DataSource) połączenie z bazą daych na podstawie konfiguracji.
	
	@GetMapping(path="/products", produces="text/plain;charset=UTF-8")
	@ResponseBody
	public String products() {
		final String sql = "SELECT product_name, price FROM products ORDER BY product_id";
		
		try(Connection c = dataSource.getConnection();
			PreparedStatement stmt = c.prepareStatement(sql);
			ResultSet rs = stmt.executeQuery()) {
			
			StringBuilder tekst = new StringBuilder("Lista produktów:\n");
			while(rs.next()) {
				tekst.append(" * ");
				tekst.append(rs.getString(1));
				tekst.append(" za cenę ");
				tekst.append(rs.getString(2));
				tekst.append('\n');
			}
			return tekst.toString();
		} catch (SQLException e) {
			e.printStackTrace();
			return "Problem z odczytaniem produktów: " + e;
		}		
	}
	
}
