package sklep.basket;

import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class BasketConfiguration {

	// Spring utworzy obiekt klasy BasketConfiguration i wykona metodę listenerSesji.
	// Uzyskany w ten sposób obiekt HttpSessionListener zostanie zarejestrowany jako listener sesji,
	// a zatem metoda sessionCreated będzie wykonywana za każdym razem, gdy w aplikacji będzie powstawać nowa sesja
	// (gdy nowy klient wejdzie na stronę).
	@Bean
	public HttpSessionListener listenerSesji() {
		return new HttpSessionListener() {
			@Override
			public void sessionCreated(HttpSessionEvent se) {
				HttpSession session = se.getSession();
				session.setAttribute("basket", new Basket());
			}
			
			@Override
			public void sessionDestroyed(HttpSessionEvent se) {
			}
		};
	}
	
}
