package sklep.przyklady;

import java.util.List;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.TypedQuery;

import sklep.model.Product;

public class OdczytajWszystkieProdukty1_JPQL {

	public static void main(String[] args) {
		EntityManagerFactory emf = Persistence.createEntityManagerFactory("sklep");
		EntityManager em = emf.createEntityManager();
		
		// Chcemy wypisać wszystkie produkty.
		// W tej wersji zadamy odpowiednie zapytania JPQL
		// JPQL = Java Persistence Query Language (czasami mówi się też HQL - Hibernate Q.L.)
		// Język wzorowany na SQL, ale:
		// - interpretowany przez Hibernate'a (lub inną implementację JPA) po stronie Javy, a nie przez serwer SQL
		// - zamiast nazw tabel i kolumn używamy nazw klas i pól
		
		TypedQuery<Product> query = em.createQuery("SELECT p FROM Product p ORDER BY p.productId", Product.class);
		List<Product> products = query.getResultList();
		System.out.println("Odczytano " + products.size() + " rekordów.");
		for (Product product : products) {
			System.out.println(" * " + product.getProductName() + " za cenę " + product.getPrice() + ", opis: " + product.getDescription());			
		}
		
		em.close();
		emf.close();
	}

}
