package sklep.web;

import javax.servlet.annotation.WebListener;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;

import sklep.basket.Basket;

@WebListener
public class BasketListener implements HttpSessionListener {
	/* Listener to jest klasa, w której możemy podać własne kody, które serwer wykona w odpowiednim momencie działania aplikacji.
	 * Tutaj obsługujemy zdarzenia utworzenia nowej sesji (i wtedy umieszczamy w sesji pusty koszyk)
	 * i zakończenia sesji.
	 */

    public void sessionCreated(HttpSessionEvent se)  { 
         HttpSession session = se.getSession();
         System.out.println("Nowa sesja: " + session.getId());
         session.setMaxInactiveInterval(30);
         session.setAttribute("basket", new Basket());
    }

    public void sessionDestroyed(HttpSessionEvent se)  { 
        HttpSession session = se.getSession();
        System.out.println("Koniec sesji: " + session.getId());
    }
	
}
