CREATE TABLE products (
	product_id SERIAL PRIMARY KEY,
	product_name VARCHAR(100) NOT NULL, -- tekst o dł maksymalnie 100 znaków
	price NUMERIC(10, 2) NOT NULL, -- max 10 cyfr, z czego 2 to cyfry po przecinku
	vat NUMERIC(2, 2), -- wartości do 0.99
	description TEXT -- w PostgreSQL TEXT, a w Oracle CLOB to są "duże fragmenty tekstu"
	
);


-- W celach dydaktycznych: kluczem nie musi być liczba, może być tekst
CREATE TABLE customers (
	customer_email VARCHAR(100) PRIMARY KEY,
	customer_name VARCHAR(100) NOT NULL,
	phone_number VARCHAR(20),
	address VARCHAR(200),
	postal_code CHAR(6),
	city VARCHAR(100)
);


-- REFERENCES oznacza "klucz obcy", za pomocą tej wartości wskazujemy klienta, który złożył zamówienie
-- technicznie: do pola orders.customer_email można wpisać tylko taką wartość, która wystepuje gdzieś w customers.customer_email
CREATE TABLE orders (
	order_id SERIAL PRIMARY KEY,
	customer_email VARCHAR(100) NOT NULL REFERENCES customers(customer_email),
	status VARCHAR(10) NOT NULL,
	order_date TIMESTAMP NOT NULL,
	delivery_date DATE
);

-- Tabela łączy zamówienia z produktami.
-- Jeśli w tej tabeli istnieje wpis z order_id=X i product_id=Y,
-- to znaczy, że w zamówieniu X wystepuje produkt Y
-- Dodatkowo zaposujemy informację o liczbie sztuk i cenie, po której towar był kupowany.
-- W tej tabeli mamy też dwukolumnowy klucz główny - unikalna jest para order_id×product_id
CREATE TABLE order_products (
	order_id INTEGER NOT NULL REFERENCES orders(order_id),
	product_id INTEGER NOT NULL REFERENCES products(product_id),
	quantity SMALLINT NOT NULL,
	actual_price NUMERIC(10, 2) NOT NULL,
	PRIMARY KEY(order_id, product_id)
);


