package parametry;

import java.io.IOException;
import java.io.PrintWriter;

import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@WebServlet("/Formularz")
public class Formularz extends HttpServlet {
	private static final long serialVersionUID = 1L;

	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		response.setContentType("text/html");
		response.setCharacterEncoding("UTF-8");
		PrintWriter out = response.getWriter();
		
		// Normalnie parametry zapytań biorą się stąd, że uzytkwnicy wpisuję do pól "formularza".
		
		out.println("<!DOCTYPE html>");
		out.println("<html>");
		out.println("<head>");
		out.println("<title>Rozmowa serwletowa</title>");
		out.println("<link rel='stylesheet' type='text/css' href='styl.css'>");
		out.println("</head>");
		out.println("<body>");
		out.println("<h1>Rozmowa serwletowa</h1>");
		out.println("<form>");
		out.println("<div>");
		out.println("<label for='imie'>Jak masz na imię?</label>");
		out.println("<input name='imie' type='text'>");
		out.println("</div>");
		out.println("<div>");
		out.println("<label for='wiek'>Ile masz lat?</label>");
		out.println("<input name='wiek' type='number'>");
		out.println("</div>");
		out.println("<button>Wyślij</button>");
		out.println("</form>");
		
		String imie = request.getParameter("imie");
		if(imie != null) {
			out.println("<div>");
			out.println("Witaj " + imie + "!");
			
			String wiekTekstowo = request.getParameter("wiek");
			if(wiekTekstowo != null) {
				int wiek = Integer.parseInt(wiekTekstowo);
				if(wiek >= 18) {
					out.println("<br>Chodź na piwo");
				} else {
					out.println("<br>Może czekoladę?");
				}
			}
			out.println("</div>");
		}
		out.println("</body>");
		out.println("</html>");
	}

}
