package zajecia.postgresql;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import javax.swing.JOptionPane;

/* Ta wersja dokonuje filtrowania po stronie bazy danych (WHERE), co jest dobre,
 * ale dane wprowadzone przez uzytkownika dokleja bezpośrednio do treści zapytania SQL,
 * co daje możliwość wpisania dowolnego kodu SQL, który wykona baza danych.
 * To się nazywa "SQL injection", poważny błąd bezpieczeństwa aplikacji.
 * 
 * Przykłady inputów, które prowadziły do problemów:
 * - IT_PROG'; UPDATE employees SET salary = 30000 WHERE last_name = 'Austin
 * - '; UPDATE employees SET salary = 1; SELECT '
 * - '; DROP TABLE employees CASCADE; SELECT ' 
 */

public class OdczytajWybranych_v2_Where {

	public static void main(String[] args) {
		String szukanyJob = JOptionPane.showInputDialog("Podaj kod stanowiska, np. IT_PROG");
		// TODO wypisz tych pracowników, którzy mają taki job_id

		try(Connection c = DriverManager.getConnection("jdbc:postgresql://localhost:5432/hr", "kurs", "abc123");
			PreparedStatement stmt = c.prepareStatement("SELECT * FROM employees WHERE job_id = '" + szukanyJob + "'")) {
			
			System.out.println("Za chwilę wykonam: " + stmt + "\n");
			
			try(ResultSet rs = stmt.executeQuery()) {
				while(rs.next()) {
					int id = rs.getInt("employee_id");
					String firstName = rs.getString("first_name");
					String lastName = rs.getString("last_name");
					String jobId = rs.getString("job_id");
					BigDecimal salary = rs.getBigDecimal("salary");
					System.out.println("Pracownik nr " + id + ": " + firstName + " " + lastName + " (" + jobId + ") zarabia " + salary);
				}
			}
		} catch (SQLException e) {
			e.printStackTrace();
		}
	}

}
