DROP TABLE IF EXISTS order_products;
DROP TABLE IF EXISTS orders;
DROP TABLE IF EXISTS customers;
DROP TABLE IF EXISTS products;
DROP TYPE IF EXISTS order_status;
DROP SEQUENCE IF EXISTS orders_seq;
DROP SEQUENCE IF EXISTS products_seq;

CREATE SEQUENCE products_seq
    START 10;

CREATE SEQUENCE orders_seq
    START 10;

CREATE TABLE products (
    product_id INTEGER DEFAULT nextval('products_seq'),
    product_name VARCHAR(100) NOT NULL,
    price NUMERIC(10, 2) NOT NULL CHECK (price > 0),
    vat NUMERIC(2, 2) CHECK (vat >= 0), -- 0.00 do 0.99
    description TEXT,
    
    PRIMARY KEY(product_id)
);

CREATE TABLE customers (
    customer_email VARCHAR(255),
    name VARCHAR(200) NOT NULL,
    phone_number VARCHAR(20),
    address VARCHAR(200),
    postal_code CHAR(6),
    city VARCHAR(100),
    
    PRIMARY KEY(customer_email)
);

CREATE TYPE order_status AS ENUM (
    'new',
    'confirmed',
    'paid',
    'shipped',
    'closed',
    'returned'
);

CREATE TABLE orders (
    order_id INTEGER DEFAULT nextval('orders_seq'),
    customer_email VARCHAR(255) NOT NULL,
    status order_status DEFAULT 'new' NOT NULL,
    order_date TIMESTAMP DEFAULT current_timestamp,
    planned_delivery_date DATE,
    delivery_date DATE,
    
    PRIMARY KEY(order_id),
    FOREIGN KEY(customer_email) REFERENCES customers(customer_email)
);

CREATE TABLE order_products (
    order_id INTEGER NOT NULL,
    product_id INTEGER NOT NULL,
    quantity SMALLINT DEFAULT 1 NOT NULL CHECK (quantity > 0),
    actual_price NUMERIC(10, 2) NOT NULL,
    actual_vat NUMERIC(2, 2),
    
    PRIMARY KEY (order_id, product_id),
    FOREIGN KEY (order_id) REFERENCES orders(order_id),
    FOREIGN KEY (product_id) REFERENCES products(product_id)
);




INSERT INTO products(product_id, product_name, price, vat, description)
    VALUES (1, 'pralka', 2900.00, 0.23, 'Pralka szybkoobrotowa');

INSERT INTO products(product_id, product_name, price, vat, description)
    VALUES (2, 'odkurzacz', 800.00, 0.23, 'Odkurzacz automatyczny');

INSERT INTO products(product_id, product_name, price, vat, description)
    VALUES (3, 'telewizor 55"', 3300.00, 0.23, 'Telewizor 55 cali 4K');

INSERT INTO products(product_id, product_name, price, vat, description)
    VALUES (4, 'telewizor 40"', 2200.00, 0.23, 'Telewizor 40 Full HD');

INSERT INTO products(product_id, product_name, price, vat)
    VALUES (5, 'myszka gejmerska', 444.00, 0.23);

    
INSERT INTO customers(customer_email, phone_number, name, address, postal_code, city)
    VALUES ('ala@example.com', '123123123', 'Ala Kowalska', 'Jasna 14/16', '01-234', 'Warszawa');

INSERT INTO customers(customer_email, phone_number, name, address, postal_code, city)
    VALUES ('ola@example.com', '321321321', 'Ola Malinowska', 'Ciemna 133', '99-999', 'Pcim');


INSERT INTO orders(order_id, customer_email, order_date, status)
    VALUES (1, 'ala@example.com', '2021-11-20 12:30:00', 'paid');

INSERT INTO orders(order_id, customer_email, order_date, status)
    VALUES (2, 'ola@example.com', '2021-11-18 10:00:00', 'shipped');

INSERT INTO orders(order_id, customer_email)
    VALUES (3, 'ala@example.com');


INSERT INTO order_products(order_id, product_id, quantity, actual_price, actual_vat)
    VALUES (1, 1, 1, 2900.00, 0.23);
INSERT INTO order_products(order_id, product_id, quantity, actual_price, actual_vat)
    VALUES (1, 2, 3, 2400.00, 0.23);
INSERT INTO order_products(order_id, product_id, quantity, actual_price, actual_vat)
    VALUES (2, 2, 1, 800.00, 0.23);
INSERT INTO order_products(order_id, product_id, quantity, actual_price, actual_vat)
    VALUES (3, 4, 1, 2200.00, 0.23);
INSERT INTO order_products(order_id, product_id, quantity, actual_price, actual_vat)
    VALUES (3, 3, 1, 300.00, 0.23);
INSERT INTO order_products(order_id, product_id, quantity, actual_price, actual_vat)
    VALUES (3, 5, 1, 1000.00, 0.23);
